<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SkillCategories extends Model 
{

    protected $table = 'skill_categories';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function belongsToSkill()
    {
        return $this->belongsToMany('App\Models\SkillCategoriesRel', 'category_uuid');
    }

}